'use strict';

/* --------------------------------------------------------------
 emails_modal.js 2018-11-22
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2018 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 ----------------------------------------------------------------
 */

/**
 * ## Attachments Modal Controller
 *
 * This controller will handle the attachments modal dialog operations of the admin/emails page.
 *
 * @module Controllers/attachments_modal
 */
gx.controllers.module('attachments_modal', ['modal', gx.source + '/libs/emails', jse.source + '/vendor/DateJS/date'],

/** @lends module:Controllers/attachments_modal */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLE DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Reference
     *
     * @type {object}
     */
    $this = $(this),


    /**
     * Emails Main Table Selector
     *
     * @type {object}
     */
    $table = $('#emails-table'),


    /**
     * Default Module Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Module Options
     *
     * @type {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------

    /**
     * Delete old attachments request.
     *
     * @param {object} event Contains the event information.
     */
    var _onDeleteOldAttachments = function _onDeleteOldAttachments(event) {
        // Validate selected date before making the request.
        if ($this.find('#removal-date').val() === '') {
            return; // do not proceed
        }

        // Display confirmation modal before proceeding.
        var modalOptions = {
            title: jse.core.lang.translate('delete', 'buttons') + ' - ' + $this.find('#removal-date').datepicker('getDate').toString('dd.MM.yyyy'),
            content: jse.core.lang.translate('prompt_delete_old_attachments', 'emails'),
            buttons: [{
                text: jse.core.lang.translate('no', 'lightbox_buttons'),
                click: function click() {
                    $(this).dialog('close');
                }
            }, {
                text: jse.core.lang.translate('yes', 'lightbox_buttons'),
                click: function click() {
                    jse.libs.emails.deleteOldAttachments($('#removal-date').datepicker('getDate').toString('yyyy-MM-dd HH:mm:ss')).done(function (response) {
                        var size = response.size.megabytes !== 0 ? response.size.megabytes + ' Megabytes' : response.size.bytes + ' Bytes';

                        var message = jse.core.lang.translate('message_delete_old_attachments_success', 'emails') + '<br/>' + jse.core.lang.translate('count', 'admin_labels') + ': ' + response.count + ', ' + jse.core.lang.translate('size', 'db_backup') + ': ' + size;

                        jse.libs.modal.message({
                            title: 'Info',
                            content: message
                        });

                        jse.libs.emails.getAttachmentsSize($('#attachments-size'));
                        $table.DataTable().ajax.reload();
                        $this.dialog('close');
                    }).fail(function (response) {
                        var title = jse.core.lang.translate('error', 'messages');

                        jse.libs.modal.message({
                            title: title,
                            content: response.message
                        });
                    });

                    $(this).dialog('close');
                }
            }]
        };

        jse.libs.modal.message(modalOptions);
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    /**
     * Initialize method of the module, called by the engine.
     */
    module.init = function (done) {
        $this.on('click', '#delete-old-attachments', _onDeleteOldAttachments);
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
